<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Request as Req;
use App\Models\RequestTarget;

class RequestController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'requester_name' => 'required|string|max:255',
            'total_amount' => 'required|numeric',
            'targets' => 'required|array|min:1',
            'targets.*.name' => 'required|string',
            'targets.*.amount' => 'required|numeric',
        ]);

        DB::beginTransaction();
        try {
            $newRequest = Req::create([
                'requester_name' => $validated['requester_name'],
                'total_amount' => $validated['total_amount'],
            ]);

            foreach ($validated['targets'] as $t) {
                RequestTarget::create([
                    'request_id' => $newRequest->id,
                    'target_name' => $t['name'],
                    'amount' => $t['amount'],
                ]);
            }

            DB::commit();
            return response()->json(['message' => 'درخواست با موفقیت ثبت شد.'], 201);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json(['error' => 'خطا در ثبت اطلاعات'], 500);
        }
    }
}
