<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('requests', function (Blueprint $table) {
            $table->id();
            $table->string('requester_name');
            $table->decimal('total_amount',15,2);
            $table->timestamps();
        });

        Schema::create('request_targets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('request_id')->constrained('requests')->onDelete('cascade');
            $table->string('target_name');
            $table->decimal('amount',15,2);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('request_targets');
        Schema::dropIfExists('requests');
    }
};
